package gov.va.med.mhv.sm.admin.converter;


import org.springframework.stereotype.Component;

import gov.va.med.mhv.sm.admin.dto.TriageRelationDTO;
import gov.va.med.mhv.sm.admin.model.TriageGroup;
import gov.va.med.mhv.sm.admin.model.TriageRelation;
import gov.va.med.mhv.sm.admin.dto.ClinicDTO;
import gov.va.med.mhv.sm.admin.dto.PcmmProviderDTO;
import gov.va.med.mhv.sm.admin.dto.TeamDTO;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component
public class TriageRelationConverter {
	
    public static TriageRelationDTO convert(TriageRelation triageRelation){
    	
    	TriageRelationDTO dto = new TriageRelationDTO();
    	
    	dto.setId(triageRelation.getId());
    	dto.setName(triageRelation.getName());
    	dto.setCreatedDate(triageRelation.getCreatedDate());
    	dto.setModifiedDate(triageRelation.getModifiedDate());
    	dto.setActive(triageRelation.getActive());
    	dto.setVistaIen(triageRelation.getVistaIen());
    	dto.setStationNumber(triageRelation.getStationNumber());
    	dto.setTriageGroup(TriageGroupConverter.convert(triageRelation.getTriageGroup()));
    	return dto;
    }
    
	public static List<TriageRelationDTO> convertList(List<TriageRelation> source) {

		List<TriageRelationDTO> destination = new ArrayList<TriageRelationDTO>();
		for (TriageRelation a : source) {
			destination.add(convert(a));
		}
		return destination;
	}
	
	public static List<PcmmProviderDTO> convertPCMMProvidersList(Collection<TriageRelation> triageRelationList){
    	List<PcmmProviderDTO> pcmmProviderDtoList = new ArrayList<PcmmProviderDTO>();
    	for(TriageRelation tr:triageRelationList){
    		PcmmProviderDTO pcmmProviderDto = new PcmmProviderDTO();
    		pcmmProviderDto.setProviderId(new Long(tr.getVistaIen()));
    		pcmmProviderDto.setProviderName(tr.getName());
    		pcmmProviderDto.setTriageGroupId(tr.getTriageGroupId());
    		pcmmProviderDtoList.add(pcmmProviderDto);
    	}
    	return pcmmProviderDtoList;
    }

    public static List<ClinicDTO> convertClinicList(Collection<TriageRelation> triageRelationList){
    	List<ClinicDTO> clinicDtoList = new ArrayList<ClinicDTO>();
    	for(TriageRelation tr:triageRelationList){
    		ClinicDTO pcmmProviderDto = new ClinicDTO();
    		pcmmProviderDto.setClinicId(new Long(tr.getVistaIen()));
    		pcmmProviderDto.setClinicName(tr.getName());
    		pcmmProviderDto.setTriageGroupId(tr.getTriageGroupId());
    		clinicDtoList.add(pcmmProviderDto);
    	}
    	return clinicDtoList;
    }
    
    public static List<TeamDTO> convertTeamList(Collection<TriageRelation> triageRelationList){
    	List<TeamDTO> teamDtoList = new ArrayList<TeamDTO>();
    	for(TriageRelation tr:triageRelationList){
    		TeamDTO teamDto = new TeamDTO();
    		teamDto.setTeamId(new Long(tr.getVistaIen()));
    		teamDto.setTeamName(tr.getName());
    		teamDto.setTriageGroupId(tr.getTriageGroupId());
    		teamDtoList.add(teamDto);
    	}
    	return teamDtoList;
    }
    
}
